/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

//  PXIPart.m
//  PXIPart
//
//  last changed by: creysoft

#import <Cocoa/Cocoa.h>
#import "PXIFileFormat.h"
#import "PXIButtonView.h"
#import "PXIFieldView.h"


@interface PXIPart : NSObject {
	int partID; // The unique ID of the part (e.g. 5073).
	int partNumber; // The relative number of the part (e.g. card part 4.)
	int specificNumber; // The specific number of the part. (e.g. card button 2)
	
	BOOL partType; // The type of the part. YES = field, NO = button
	
	NSString * content; // The contents of the part.
	
	PXIButtonView * buttonView; // The button view.
	PXIFieldView * fieldView; // The field view.
	
	BOOL enabled;
	BOOL visible;
}

- (id) initWithFrame:(NSRect)frame ofType:(PXIPartType)type andProperties:(NSDictionary*)properties;
- (id) initWithFrame:(NSRect)frame ofType:(BOOL)newpartType withName:(NSString*)newpartName;
- (void) applyDictionary:(NSDictionary*)properties;
- (PXIButtonView*)buttonView;
- (PXIFieldView*)fieldView;
- (NSView*)currentview;

- (int)partID;
- (void)setPartID:(int)newPartid;
- (int)partNumber;
- (void)setPartNumber:(int)newPartnumber;
- (int)specificNumber;
- (void)setSpecificNumber:(int)newSpecificnumber;
- (BOOL)partType;
- (void)setPartType:(BOOL)newParttype;
- (NSString *)partName;
- (void)setPartName:(NSString *)newPartname;
- (NSString *)content;
- (void)setContent:(NSString *)newContent;
- (BOOL)autoHilite;
- (void)setAutoHilite:(BOOL)newAutohilite;
- (NSString *)fontName;
- (void)setFontName:(NSString *)newFontname;
- (int)titleWidth;
- (void)setTitleWidth:(int)newTitlewidth;
- (NSString *)partName;
- (void)setPartName:(NSString *)newPartname;
- (int)partStyle;
- (void)setPartStyle:(int)newPartstyle;
- (BOOL)visible;
- (void)setVisible:(BOOL)newVisible;
- (BOOL)enabled;
- (void)setEnabled:(BOOL)newEnabled;
- (BOOL)hilite;
- (void)setHilite:(BOOL)newHilite;
- (BOOL)showName;
- (void)setShowName:(BOOL)newShowname;
- (int)textAlign;
- (void)setTextAlign:(int)newTextalign;
- (int)textSize;
- (void)setTextSize:(int)newTextsize;
- (BOOL)lineWrap;
- (void)setLineWrap:(BOOL)newLinewrap;

/*
- (BOOL)enabled;
- (void)setEnabled:(BOOL)newEnabled;
- (BOOL)visible;
- (void)setVisible:(BOOL)newVisible;
*/

@end
